<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Raza;
use App\Models\Servicio;
use App\Models\Status;
use App\Models\Seguridad\Usuario;
use App\Models\TipoMascota;
use App\Models\Mascota;
use DB;

class MascotaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $mascota = DB::table('mascota as m')
        ->join('usuario as u','m.id_usuario','=','u.id')
        ->join('raza as r','m.id_raza','=','r.id')
        ->join('tipomascota as tm','r.id_tipomascota','=','tm.id')
        ->select('m.id as id', 'm.nombre_masc as nombre_masc', 'm.genero as genero', 'u.nombre as nombre','r.raza_mascota as raza_mascota', 'tm.tipo_mascota as tipo_mascota' )
        ->get();
        
        
       // $mascota = Mascota::orderBy('id','DESC')->get();
        //$raza = DB::table('$mascota')
        //->select('$mascota.*')
       // ->where('id_usuario', session()->get('nombre_usuario', 'Inivitado'))
       // ->get();  
        return view('mascota.index', compact('mascota'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
         $usuarioData = DB::table('usuario as u')
             ->join('usuario_rol as ur','u.id','=','ur.usuario_id')
             ->select('u.id as id', 'u.nombre')
             ->where('ur.rol_id','=', 10)
             ->get();
        
        
         $tipomascota_raza=DB::table('raza as r')
        ->join('tipomascota as tm','r.id_tipomascota','=','tm.id')
        ->select('r.raza_mascota as raza', 'tipo_mascota as t_m', 'r.id as idraza', DB::raw("concat(tipo_mascota,' - ',raza_mascota ) as tipomascota_raza"))
        ->orderBy('tm.id','DESC')
        ->get();
        return view('mascota.crear', compact('usuarioData', 'tipomascota_raza'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Mascota::create($request->all());  //guarda todos los campos 
        return redirect()->route('mascota')->with('mensaje', 'Datos creados correctamente');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = Mascota::findOrFail($id);
        $mascota = Mascota::orderBy('id','desc')->get();
        $mascotaCreate = Mascota::orderBy('id','desc')->get();
        return view('mascota.show', compact('data', 'mascotaCreate', 'mascotaCreate'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $mascota = Mascota::findOrFail($id);
        $tipoMascota = TipoMascota::orderBy('id','desc')->get();
        $usuarioData = DB::table('usuario as u')
        ->join('usuario_rol as ur','u.id','=','ur.usuario_id')
        ->select('u.id as id', 'u.nombre')
        ->where('ur.rol_id','=', 10)
        ->get();
        
        $tipomascota_raza=DB::table('raza as r')
        ->join('tipomascota as tm','r.id_tipomascota','=','tm.id')
        ->select('r.raza_mascota as raza', 'tipo_mascota as t_m', 'r.id as idraza', DB::raw("concat(tipo_mascota,' - ',raza_mascota ) as tipomascota_raza"))
        ->orderBy('tm.id','DESC')
        ->get();
        
        return view('mascota.editar', compact('mascota', 'tipoMascota','usuarioData','tipomascota_raza'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = Mascota::findOrFail($id);
       $data->update($request->all());
       return redirect()->route('mascota')->with('mensaje', 'Datos actualizados correctamente');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        if ($request->ajax()) {
         if (Mascota::destroy($id)) {
             return response()->json(['mensaje' => 'ok']);
         } else {
             return response()->json(['mensaje' => 'ng']);
         }
     } else {
         abort(404);
     }
 }
}