<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Permiso_Ddi;
use App\Models\TipoPermiso;
use App\Models\StatusPermiso;
use DB;

class MisPermisosController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $permiso_ddi = DB::table('v$permisos')
        ->select('v$permisos.*')
        ->where('id_usuario', session()->get('nombre_usuario', 'Inivitado'))
        ->get();  
        return view('mispermisos.index', compact('permiso_ddi'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
         $permiso_ddiCreate = TipoPermiso::orderBy('id','DESC')->get();
        return view('mispermisos.crear', compact('permiso_ddiCreate'));
       //return view('permiso_ddi.crear');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Permiso_Ddi::create($request->all());  //guarda todos los campos 
        return redirect()->route('mispermisos')->with('mensaje', 'Datos creados correctamente');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = Permiso_Ddi::findOrFail($id);
        $permiso_ddiCreate = TipoPermiso::orderBy('id','desc')->get();
        $status_ddiCreate = StatusPermiso::orderBy('id','desc')->get();
        return view('mispermisos.show', compact('data', 'permiso_ddiCreate', 'status_ddiCreate'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Permiso_Ddi::findOrFail($id);
        $permiso_ddiCreate = TipoPermiso::orderBy('id','desc')->get();
        $status_ddiCreate = StatusPermiso::select('*')->where('id', '10')->orwhere('id', '11')->orderBy('id','desc')->get();
        return view('mispermisos.editar', compact('data', 'permiso_ddiCreate', 'status_ddiCreate'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = Permiso_Ddi::findOrFail($id);
       $data->update($request->all());
       return redirect()->route('mispermisos')->with('mensaje', 'Datos actualizados correctamente');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        if ($request->ajax()) {
         if (Permiso_Ddi::destroy($id)) {
             return response()->json(['mensaje' => 'ok']);
         } else {
             return response()->json(['mensaje' => 'ng']);
         }
     } else {
         abort(404);
     }
 }
}