<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Perm_Year;
use App\Models\Seguridad\Usuario;
use DB;


class Perm_YearController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $perm_year = Perm_Year::orderBy('id','DESC')->get();  // decs = descendente y asc, ascendente
        
         $perm_year=DB::table('perm_year as p')
        //->join('usuario as u', 'u.id', '=', 'p.id_usuario')
        ->select('p.id as id', 'p.id_usuario as nombre', 'p.year as year', 'p.dias_fla_asig as dias_fla_asig', 'p.dias_fla_usados as dias_fla_usados', 'p.dias_228_asignado as dias_228_asignado', 'p.dias_228_usados as dias_228_usados')
        ->get();
        
        
        return view('perm_year.index', compact('perm_year'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $creat_perm_year = Usuario::orderBy('usuario','DESC')->where('id','<>', 1)->get();  // decs = descendente y asc, ascendente
        $perm_year = Perm_Year::orderBy('id','DESC')->get();  // decs = descendente y asc, ascendente
        return view('perm_year.crear', compact('creat_perm_year', 'perm_year' ));
}

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Perm_Year::create($request->all());  //guarda todos los campos 
        return redirect()->route('perm_year')->with('mensaje', 'Datos creados correctamente');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Perm_Year::findOrFail($id);
        return view('perm_year.editar', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = Perm_Year::findOrFail($id);
       $data->update($request->all());
       return redirect()->route('perm_year')->with('mensaje', 'Datos actualizados correctamente');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        if ($request->ajax()) {
         if (Perm_Year::destroy($id)) {
             return response()->json(['mensaje' => 'ok']);
         } else {
             return response()->json(['mensaje' => 'ng']);
         }
     } else {
         abort(404);
     }
 }
}
