<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Permiso_Ddi;
use App\Models\TipoPermiso;
use App\Models\StatusPermiso;
use DB;

class Permiso_DdiController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $permiso_ddi = DB::select('select * from v$permisos');
        return view('permiso_ddi.index', compact('permiso_ddi'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
         $permiso_ddiCreate = TipoPermiso::orderBy('id','DESC')->get();
        return view('permiso_ddi.crear', compact('permiso_ddiCreate'));
       //return view('permiso_ddi.crear');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Permiso_Ddi::create($request->all());  //guarda todos los campos 
        return redirect()->route('permiso_ddi')->with('mensaje', 'Datos creados correctamente');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Permiso_Ddi::findOrFail($id);
        $permiso_ddiCreate = TipoPermiso::orderBy('id','desc')->get();
        $status_ddiCreate = StatusPermiso::select('*')->where('id', '8')->orwhere('id', '9')->orwhere('id', '11')->orderBy('id','desc')->get();
        return view('permiso_ddi.editar', compact('data', 'permiso_ddiCreate', 'status_ddiCreate'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request54
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = Permiso_Ddi::findOrFail($id);
       $data->update($request->all());
       return redirect()->route('permiso_ddi')->with('mensaje', 'Datos actualizados correctamente');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        if ($request->ajax()) {
         if (Permiso_Ddi::destroy($id)) {
             return response()->json(['mensaje' => 'ok']);
         } else {
             return response()->json(['mensaje' => 'ng']);
         }
     } else {
         abort(404);
     }
 }
    
     public function permisoPDF($id)
    {  
        $data = Permiso_Ddi::findOrFail($id);
        $permiso_ddiCreate = TipoPermiso::orderBy('id','desc')->get();
        $status_ddiCreate = StatusPermiso::select('*')->orderBy('id','desc')->get();

        $pdf  =  \App::make('dompdf.wrapper');
        $view =  view('permiso_ddi.permisoPDF',compact('data', 'permiso_ddiCreate', 'status_ddiCreate'))->render();

        $dom_pdf = $pdf->getDomPDF();
        $canvas = $dom_pdf ->get_canvas();
        $canvas->page_text(260, 820, "Página {PAGE_NUM} de {PAGE_COUNT}", null, 10, array(0, 0, 0));

        $pdf->loadHTML($view);
  
        return $pdf->stream('Permiso - '.$data->id.'.pdf');
    }
}
