<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Raza;
use App\Models\Seguridad\Usuario;
use App\Models\Status;
use App\Models\Prestacion;
use App\Models\Mascota;
use App\Models\Servicio;
use DB;


class PrestacionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //$prestacion = Prestacion::orderBy('id','DESC')->get();  // decs = descendente y asc, ascendente
        
         $prestacion=DB::table('prestacion as p')
        ->join('mascota as m', 'p.id_mascota', '=', 'm.id')
        ->join('status as s', 'p.id_status', '=', 's.id')
        ->join('servicio as ser', 'p.id_servicio', '=', 'ser.id')
        ->join('usuario as u', 'p.id_profesional', '=', 'u.id')
        ->select('p.id','m.nombre_masc','s.status_hora_atenc', 'ser.nombre_servicio', 'p.hora_solic', 'p.fecha_solic', 'u.nombre')
        ->get();
        
        
        return view('prestacion.index', compact('prestacion'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $mascota = Mascota::orderBy('nombre_masc','DESC')->get();
        $servicio = Servicio::orderBy('nombre_servicio','DESC')->get();
        $usuarioData = DB::table('usuario as u')
             ->join('usuario_rol as ur','u.id','=','ur.usuario_id')
             ->select('u.id as id', 'u.nombre')
             ->where('ur.rol_id','=', 10)
             ->get();
        
        return view('prestacion.crear', compact('mascota','servicio','usuarioData'));
}

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       Prestacion::create($request->all());
        return redirect()->route('prestacion')->with('mensaje', 'Datos creados correctamente');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Prestacion::findOrFail($id);
        $mascota = Mascota::orderBy('nombre_masc','DESC')->get();
        $servicio = Servicio::orderBy('nombre_servicio','DESC')->get();
        $usuarioData = DB::table('usuario as u')
             ->join('usuario_rol as ur','u.id','=','ur.usuario_id')
             ->select('u.id as id', 'u.nombre')
             ->where('ur.rol_id','=', 10)
             ->get();
        return view('prestacion.editar', compact('data','mascota','servicio','usuarioData'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = Prestacion::findOrFail($id);
       $data->update($request->all());
       return redirect()->route('prestacion')->with('mensaje', 'Datos actualizados correctamente');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        if ($request->ajax()) {
         if (Prestacion::destroy($id)) {
             return response()->json(['mensaje' => 'ok']);
         } else {
             return response()->json(['mensaje' => 'ng']);
         }
     } else {
         abort(404);
     }
 }
}
