<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Seguridad\Usuario;
use App\Models\Raza;
use App\Models\Mascota;
use App\Models\TipoMascota;
use DB;


class RazaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {       
         $raza=DB::table('raza as r')
        ->join('tipomascota as tp', 'r.id_tipomascota', '=', 'tp.id')
        ->select('r.id as id', 'r.raza_mascota as raza_mascota', 'tp.tipo_mascota as tipo_mascota')
        ->get();
        
        return view('raza.index', compact('raza'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data = TipoMascota::orderBy('id','DESC')->get();
        
        return view('raza.crear', compact('data'));
}

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Raza::create($request->all());  //guarda todos los campos 
        return redirect()->route('raza')->with('mensaje', 'Datos creados correctamente');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Raza::findOrFail($id);
        $tipomascota = TipoMascota::orderBy('id','DESC')->get();
        return view('raza.editar', compact('data','tipomascota'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       $data = Raza::findOrFail($id);
       $data->update($request->all());
       return redirect()->route('raza')->with('mensaje', 'Datos actualizados correctamente');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        if ($request->ajax()) {
         if (Raza::destroy($id)) {
             return response()->json(['mensaje' => 'ok']);
         } else {
             return response()->json(['mensaje' => 'ng']);
         }
     } else {
         abort(404);
     }
 }
}
