<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\StatusPermiso;

class StatusPermisoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $statuspermiso = StatusPermiso::orderBy('status_permiso','DESC')->get();
        return view('statuspermiso.index', compact('statuspermiso'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
               /* $statuspermisoCreate = StatusPermiso::orderBy('status_permiso','DESC')->get();
        return view('statuspermiso.crear', compact('statuspermisoCreate'));*/
        return view('statuspermiso.crear');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        StatusPermiso::create($request->all());  //guarda todos los campos 
        return redirect()->route('statuspermiso')->with('mensaje', 'Datos creados correctamente');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = StatusPermiso::findOrFail($id);
        return view('statuspermiso.editar', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = StatusPermiso::findOrFail($id);
       $data->update($request->all());
       return redirect()->route('statuspermiso')->with('mensaje', 'Datos actualizados correctamente');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
       if ($request->ajax()) {
        if (StatusPermiso::destroy($id)) {
            return response()->json(['mensaje' => 'ok']);
        } else {
            return response()->json(['mensaje' => 'ng']);
        }
    } else {
        abort(404);
    }
}
}
