<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\TipoMascota;
use App\Models\Seguridad\Usuario;
use DB;


class TipoMascotaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $tipomascota = TipoMascota::orderBy('id','DESC')->get();  // decs = descendente y asc, ascendente
        
         $tipomascota=DB::table('tipomascota as p')
        //->join('usuario as u', 'u.id', '=', 'p.id_usuario')
        //->select('p.id as id', 'p.id_usuario as nombre', 'p.year as year', 'p.dias_fla_asig as dias_fla_asig', 'p.dias_fla_usados as dias_fla_usados', 'p.dias_228_asignado as dias_228_asignado', 'p.dias_228_usados as dias_228_usados')
        ->get();
        
        
        return view('tipomascota.index', compact('tipomascota'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $creat_tipomascota = TipoMascota::orderBy('tipo_mascota','DESC')->get();  // decs = descendente y asc, ascendente
        $tipomascota = TipoMascota::orderBy('id','DESC')->get();  // decs = descendente y asc, ascendente
        return view('tipomascota.crear', compact('creat_tipomascota', 'tipomascota' ));
}

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        TipoMascota::create($request->all());  //guarda todos los campos 
        return redirect()->route('tipomascota')->with('mensaje', 'Datos creados correctamente');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = TipoMascota::findOrFail($id);
        return view('tipomascota.editar', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = TipoMascota::findOrFail($id);
       $data->update($request->all());
       return redirect()->route('tipomascota')->with('mensaje', 'Datos actualizados correctamente');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        if ($request->ajax()) {
         if (TipoMascota::destroy($id)) {
             return response()->json(['mensaje' => 'ok']);
         } else {
             return response()->json(['mensaje' => 'ng']);
         }
     } else {
         abort(404);
     }
 }
}
