<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePresupuestosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('presupuestos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('cliente_id');
            $table->string('campania')->nullable();
            $table->string('vendedor')->nullable();
            $table->string('estado_id')->nullable();
            $table->date('fecha_entrega')->nullable();
            $table->string('descripcion')->nullable();
            $table->string('observaciones')->nullable();
            $table->float('totalMateriales');
            $table->float('totalOperaciones');
            $table->float('costoPresupuesto');
            $table->float('margen');
            $table->float('netoPresupuesto');
            $table->float('ivaPresupuesto');
            $table->float('totalPresupuesto');
            $table->integer('ot')->default(0);

            $table->timestamps();
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_spanish_ci';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('presupuestos');
    }
}
