<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDetallePresupuestoProductosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detalle_presupuesto_productos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('presupuesto_id');
            $table->string('producto')->nullable();
            $table->integer('ejemplares')->default(1);
            $table->integer('formato_terminado_ancho')->default(0);
            $table->integer('formato_terminado_alto')->default(0);
            $table->integer('formato_extendido_ancho')->default(0);
            $table->integer('formato_extendido_alto')->default(0);
            $table->unsignedBigInteger('maquina_id');
            $table->unsignedBigInteger('sustrato_primario_id');
            $table->integer('cantidad_ancho')->default(0);
            $table->integer('cantidad_alto')->default(0);
            $table->integer('cantidad_tinta_tiro')->default(1);
            $table->integer('cantidad_tinta_retiro')->default(0);
            $table->integer('cantidad_paginas')->default(1);
            $table->integer('cantidad_merma')->default(0);
            $table->integer('dias_entrega')->nullable();
            $table->float('tamanio');
            $table->float('valorunitario');
            $table->float('valortotal');
            $table->string('observaciones')->nullable();
            $table->integer('estado_id')->default(4);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detalle_presupuesto_productos');
    }
}
