<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMaquinaSustratoprimariosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('maquina_sustratoprimarios', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('maquina_id');
            $table->foreign('maquina_id', 'fk_maquinasustratoprimarios_maquina')->references('id')->on('maquinas')->onDelete('restrict')->onUpdate('restrict');
            $table->unsignedBigInteger('sustratoprimario_id');
            $table->foreign('sustratoprimario_id', 'fk_maquinasustratoprimarios_sustrato_primarios')->references('id')->on('sustrato_primarios')->onDelete('restrict')->onUpdate('restrict');
            $table->timestamps();
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_spanish_ci';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('maquina_sustratoprimarios');
    }
}
