@extends("theme.$theme.layout")
@section('titulo')
CLINICA VETERINARIA
@endsection

@section("styles")
<link href="{{asset("assets/js/bootstrap-fileinput/css/fileinput.min.css")}}" rel="stylesheet" type="text/css"/>
@endsection

@section("scriptsPlugins")
<script src="{{asset("assets/js/bootstrap-fileinput/js/fileinput.min.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/js/locales/es.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/themes/fas/theme.min.js")}}" type="text/javascript"></script>
@endsection

@section('contenido')
<div class="row">
    <div class="col-lg-12">
        @include('includes.mensaje')
        @include('includes.form-error')
        <div class="box box-danger">
            <div class="box-header with-border">
                <h3 class="box-title">FORMULARIO DE CREACIÓN DE MASCOTA</h3>
                <a href="{{route('mascota')}}" class="btn btn-info btn-sm pull-right">Volver al listado</a>
            </div>
            <form action="{{route('guardar_mascota')}}" id="form-general" class="form-horizontal" method="POST" autocomplete="off" enctype="multipart/form-data">
                @csrf
                <div class="box-body">

               <!-- El siguiente campo muestra el nombre del usuario que ingresa a la sesión-->  
               <!-- tex = muestra hidden= oculta, readonly = indica un campo NO modificable-->

               <!--  <td><strong><input type="text" name="id_usuario" class="form-control text-center"  value="{{session()->get('nombre_masc', 'id_usuario', 'tipo_mascota', 'genero')}} " readonly/></strong></td> e-->
               <div class="form-group">
                <label for="nombre_masc"   class="text-right col-lg-3 control-label requerido">Nombre Mascota</label>
                 <div  class="col-lg-8">
                  <input type="text" name="nombre_masc" id="nombre_masc" class="form-control" placeholder="nombre de mascota" required/>
                </div>


    </div>
                <!--Genero de Mascota -->
                <div class="form-group">
                <label for="genero"   class="text-right col-lg-3 control-label requerido">Género de la Mascota</label>
                 <div  class="col-lg-8">
                  <input type="text" name="genero" id="genero" class="form-control" placeholder="Macho / Hembra" required/>
          </div>
    </div>
                <!-- Fin Genero de Mascota -->

                <!-- Seleccion multiple de Dueños de mascota  -->                    
                <div class="form-group">
                <label for="id_usuario" class="col-lg-3 control-label requerido"> Dueño</label>
                <div class="col-lg-8">
                <select name="id_usuario" class="form-control">
                @foreach( $usuarioData as $usuario_Data)
                <option value="{{ $usuario_Data->id}}">{{ $usuario_Data->nombre }}</option>
                @endforeach                       
                </select>
                </div>
                </div> 
                <!-- Fin seleccion multiple personal -->

                <!-- Seleccion multiple de tipo de mascota/raza  -->                    
                <div class="form-group">
                <label for="id_raza" class="col-lg-3 control-label requerido"> Tipo mascota/Raza</label>
                <div class="col-lg-8">
                <select name="id_raza" class="form-control">
                @foreach( $tipomascota_raza as $tipomascotas_razas)
                <option value="{{ $tipomascotas_razas->idraza}}">{{ $tipomascotas_razas->tipomascota_raza }}</option>
               
                @endforeach                       
                </select>
                </div>
                </div> 
                <!-- Fin seleccion multiple tipo de mascota/raza -->



   
                </div>
                <div class="box-footer">
                    <div class="col-lg-3"></div>
                    <div class="col-lg-6">
                        @include('includes.boton-form-crear')
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection