@extends("theme.$theme.layout")
@section('titulo')
CLINICA VETERINARIA
@endsection

@section("styles")
<link href="{{asset("assets/js/bootstrap-fileinput/css/fileinput.min.css")}}" rel="stylesheet" type="text/css"/>
@endsection

@section("scriptsPlugins")
<script src="{{asset("assets/js/bootstrap-fileinput/js/fileinput.min.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/js/locales/es.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/themes/fas/theme.min.js")}}" type="text/javascript"></script>
@endsection

@section('contenido')
<div class="row">
    <div class="col-lg-12">
        @include('includes.mensaje')
        @include('includes.form-error')
        <div class="box box-danger">
            <div class="box-header with-border">
                <h3 class="box-title">Editar {{$mascota->mascota}}</h3>
                <a href="{{route('mascota')}}" class="btn btn-info btn-sm pull-right">Volver al listado</a>
            </div>
            <form action="{{route('actualizar_mascota', $mascota->id)}}" id="form-general" class="form-horizontal" method="POST" autocomplete="off" enctype="multipart/form-data">
                @csrf @method("put")
                <div class="box-body">

                    <div class="form-group">
    <label for="nombre_masc"   class="text-right col-lg-3 control-label requerido">Nombre de mascota</label>
    <div  class="col-lg-8">
    <input type="text" name="nombre_masc" id="nombre_masc" class="form-control" placeholder="Nombre de mascota" value="{{old('nombre_masc', $mascota->nombre_masc ?? '')}}" required/>
    </div>
</div>


<div class="form-group">
    <label for="genero"   class="text-right col-lg-3 control-label requerido">Genero de mascota</label>
    <div  class="col-lg-8">
    <input type="text" name="genero" id="genero" class="form-control" placeholder="Genero de mascota" value="{{old('genero', $mascota->genero ?? '')}}" required/>
    </div>
</div>
                            
                <!-- Seleccion multiple de TIPO MASCOTA-->                    
                <div class="form-group">
                <label for="id_usuario" class="col-lg-3 control-label requerido"> Dueño </label>
                <div class="col-lg-8">
                <select name="id_usuario" class="form-control">
                @foreach ($usuarioData as $usuarioData)  <!-- set de datos que paso a edith -->  
                <option value="{{ $usuarioData->id }}" 
                @if ($usuarioData->id == $mascota->id_usuario)
                selected="selected"
                @endif>
                {{ $usuarioData->nombre }}</option>  <!-- SET DE DATOS -->  
                @endforeach               
                </select>
                </div>
                </div> 
<!-- Fin seleccion multiple TIPO MASCOTA -->
        <div class="form-group">
                <label for="id_raza" class="col-lg-3 control-label requerido"> Raza/Tipo mascota </label>
                <div class="col-lg-8">
                <select name="id_raza" class="form-control">
                @foreach ($tipomascota_raza as $tipomascota_raza)  <!-- set de datos que paso a edith -->  
                <option value="{{ $tipomascota_raza->idraza }}" 
                @if ($tipomascota_raza->idraza == $mascota->id_raza)
                selected="selected"
                @endif>
                {{ $tipomascota_raza->tipomascota_raza }}</option>  <!-- SET DE DATOS -->  
                @endforeach               
                </select>
                </div>
                </div>                

                   
                </div>
                <div class="box-footer">
                    <div class="col-lg-3"></div>
                    <div class="col-lg-6">
                        @include('includes.boton-form-editar')
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection