@extends("theme.$theme.layout")
@section('titulo')
CLINICA VETERINARIA
@endsection
@section("scripts")
<script src="{{asset("assets/pages/scripts/libro/index.js")}}" type="text/javascript"></script>
@endsection
<style></style>

@section('contenido')
<div class="row">
    <div class="col-lg-12">
        @csrf
        @include('includes.mensaje')
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Esta página permite ingresar los datos de la Mascota </h3> <!-- Titulos de página-->
                <br>
                <h3 class="box-title">____________________________________________________</h3>
                <div class="box-tools pull-right">
                    <a href="{{route('crear_mascota')}}" class="btn btn-block btn-success btn-sm"> <!-- route lista-->
                        <i class="fa fa-fw fa-plus-circle"></i> INGRESAR DATOS DE MASCOTA
                    </a>
                </div>
              
            <!--</div>  <td><strong><input type="text" name="id_usuario" class="form-control text-center"  value="{{session()->get('nombre_usuario', 'Inivitado')}} " readonly/></strong></td> -->

            <div class="box-body">
                <table class="table table-striped table-bordered table-hover" id="tabla-data">
               
                    <thead>
                        <tr>
                       
                            <!-- Campos que se verán en la página Atención médica de la mascota-->
                             <th>id</th>
                            <th>Nombre de la Mascota</th>
                            <th>Genero</th>
                            <th>Dueño</th>
                            <th>Tipo Mascota</th>
                            <th>Raza Mascota</th>
                            <th class="width70"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($mascota as $mascota)<!--primer mascota es el set de datos y el segundo ALIAS con el cual se puede llamar a cada columna  -->
                        <tr>                            
                            <td>{{$mascota->id}}</td>
                            <td>{{$mascota->nombre_masc}}</td> 
                            <td>{{$mascota->genero}}</td> 
                            <td>{{$mascota->nombre}}</td>     
                            <td>{{$mascota->raza_mascota}}</td>  
                            <td>{{$mascota->tipo_mascota}}</td>  
                            <td>
                           <!--     <a href="{{route('show_mascota', ['id' => $mascota->id])}}" class="btn-accion-tabla tooltipsC" title="Ver este registro">
                                    <i class="fa fa-eye"></i>
                                </a>-->
                              <!-- INICIO, permite de acuerdo a status, GUARDAR = BORRADOR, -->
                               
                                 <a href="{{route('editar_mascota', ['id' => $mascota->id])}}" class="btn-accion-tabla tooltipsC" title="Editar este registro">
                                    <i class="fa fa-fw fa-pencil"></i>
                                </a>
                                <form action="{{route('eliminar_mascota', ['id' => $mascota->id])}}" class="d-inline form-eliminar" method="POST">
                                    @csrf @method("delete")
                                    <button type="submit" class="btn-accion-tabla eliminar tooltipsC" title="Eliminar este registro">
                                        <i class="fa fa-fw fa-trash text-danger"></i>
                                    </button>
                                </form>
                                
       
                            </td>
                        </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-ver-libro" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Categoría</h4>
            </div>
            <div class="modal-body"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
@endsection