@extends("theme.$theme.layout")
@section('titulo')
Gestión de Vacaciones
@endsection

@section("styles")
<link href="{{asset("assets/js/bootstrap-fileinput/css/fileinput.min.css")}}" rel="stylesheet" type="text/css"/>
@endsection

@section("scriptsPlugins")
<script src="{{asset("assets/js/bootstrap-fileinput/js/fileinput.min.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/js/locales/es.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/themes/fas/theme.min.js")}}" type="text/javascript"></script>
@endsection

@section('contenido')
<div class="row">
    <div class="col-lg-12">
        @include('includes.mensaje')
        @include('includes.form-error')
        <div class="box box-danger">
            <div class="box-header with-border">
                <h3 class="box-title">Editar {{$data->permiso_ddi}}</h3>
                <a href="{{route('mispermisos')}}" class="btn btn-info btn-sm pull-right">Volver al listado</a>
            </div>
            <form action="{{route('actualizar_mispermisos', $data->id)}}" id="form-general" class="form-horizontal" method="POST" autocomplete="off" enctype="multipart/form-data">
                @csrf @method("put")
                <div class="box-body">

                               <!-- Seleccion multiple de ESTATUS DEL PERMSO -->                    
                               <div class="form-group">
                        <label for="status" class="col-lg-3 control-label requerido"> ESTATUS DE PERMISO </label>
                        <div class="col-lg-8">
                 <select name="status" class="form-control">
                  @foreach ($status_ddiCreate as $usuario)
                  <option value="{{ $usuario->id }}" 
                    @if ($usuario->id == $data->status)
                    selected="selected"
                    @endif>
                    {{ $usuario->status_permiso }}</option>
                    @endforeach               
                </select>
                        </div>
                    </div> 
                <!-- Fin seleccion multiple ESTATUS DEL PERMSO -->
                    
           
                    
          

                <!-- Seleccion multiple TIPO PERMISO  -->                    
                <div class="form-group">
                        <label for="id_tabla_tipo_permiso" class="col-lg-3 control-label requerido"> TIPO DE PERMISO A SOLICITAR </label>
                        <div class="col-lg-8">
                            
                    <select name="id_tabla_tipo_permiso" class="form-control">
                  @foreach ($permiso_ddiCreate as $usuario)
                  <option value="{{ $usuario->tipo_permiso }}" 
                    @if ($usuario->tipo_permiso == $data->id_tabla_tipo_permiso)
                    selected="selected"
                    @endif>
                    {{ $usuario->tipo_permiso }}</option>
                    @endforeach               
                </select>
                            
                  <!--  <select name="id_tabla_tipo_permiso" class="form-control">
                                    @foreach($permiso_ddiCreate as $usuario)
                                            <option value="{{ $usuario->tipo_permiso}}">{{ $usuario->tipo_permiso }}</option>
                                            @endforeach                       
                                    </select>
                            
                       -->     
                            
                            
                        </div>
                    </div> 
                <!-- Fin seleccion multiple TIPO PERMISO-->

                    @include('mispermisos.form')<!-- invoca al archivo form.blade.php -->
                </div>
                <div class="box-footer">
                    <div class="col-lg-3"></div>
                    <div class="col-lg-6">
                        @include('includes.boton-form-editar')
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection