@extends("theme.$theme.layout")
@section('titulo')
Gestión Vacaciones
@endsection

@section("styles")
<link href="{{asset("assets/js/bootstrap-fileinput/css/fileinput.min.css")}}" rel="stylesheet" type="text/css"/>
@endsection

@section("scriptsPlugins")
<script src="{{asset("assets/js/bootstrap-fileinput/js/fileinput.min.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/js/locales/es.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/themes/fas/theme.min.js")}}" type="text/javascript"></script>
@endsection

@section('contenido')
<div class="row">
    <div class="col-lg-12">
        @include('includes.mensaje')
        @include('includes.form-error')
        <div class="box box-danger">
            <div class="box-header with-border">
                <h3 class="box-title">Crear Permiso por año</h3>
                <br>
                <h3 class="box-title">Esta página permite asignar los días de FLA del Departamento.</h3>
                <br>
                <h3 class="box-title">Si el usuario no aparece, debe ser creado por al Administrador en la pestaña usuarios</h3>
                <a href="{{route('perm_year')}}" class="btn btn-info btn-sm pull-right">Volver al listado</a>
            </div>
            <form action="{{route('guardar_perm_year')}}" id="form-general" class="form-horizontal" method="POST" autocomplete="off" enctype="multipart/form-data">
                @csrf
                <div class="box-body">
                    
<!-- Seleccion multiple de personal  -->                    
<div class="form-group">
    <label for="year" class="col-lg-3 control-label requerido"> Funcionario </label>
    <div class="col-lg-8">
   <select name="id_usuario" class="form-control">
                 @foreach($creat_perm_year as $usuario)
                           <option value="{{ $usuario->id}}">{{ $usuario->nombre }}</option>
                           @endforeach                       
                </select>
    </div>
</div> 
<!-- Fin seleccion multiple personal -->

                    @include('perm_year.form') <!-- llama a fichero form.blade.php llama a year y a dias_fla_asig -->
                </div>
                <div class="box-footer">
                    <div class="col-lg-3"></div>
                    <div class="col-lg-6">
                        @include('includes.boton-form-crear')
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection