@extends("theme.$theme.layout")
@section('titulo')
Gestion Vacaciones
@endsection
@section("scripts")
<script src="{{asset("assets/pages/scripts/libro/index.js")}}" type="text/javascript"></script>
@endsection
<style></style>

@section('contenido')
<div class="row">
    <div class="col-lg-12">
        @csrf
        @include('includes.mensaje')
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Días Asignado por año a FLA y 228 </h3> <!-- Titulos de página-->
                <br>
                <h3 class="box-title">Esta página permite crear o borrar usuarios y sus días de FLA, 228 son constantes</h3>
                <div class="box-tools pull-right">
                    <a href="{{route('crear_perm_year')}}" class="btn btn-block btn-success btn-sm"> <!-- route lista-->
                        <i class="fa fa-fw fa-plus-circle"></i> Nuevo registro
                    </a>
                </div>
            </div>
            <div class="box-body">
                <table class="table table-striped table-bordered table-hover" id="tabla-data">
                    <thead>
                        <tr>
                             <!-- Campos que se verán en la página Permisos por año-->
                            <th>Id</th>
                            <th>Funcionario</th>
                            <th>Año</th>
                            <th>Días FLA asignado</th>
                            <th>Días FLA usado</th>
                            <th>Días 228 asignado</th>
                            <th>Días 228 usado</th>
                            <th class="width70"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($perm_year as $permiso)
                        <tr>
                            
                            <td>{{$permiso->id}}</td>
                            <td>{{$permiso->nombre}}</td>
                            <td>{{$permiso->year}}</td>
                            <td>{{$permiso->dias_fla_asig}}</td>
                            <td>{{$permiso->dias_fla_usados}}</td>
                            <td>{{$permiso->dias_228_asignado}}</td>
                            <td>{{$permiso->dias_228_usados}}</td>
                            <td>
                                <a href="{{route('editar_perm_year', ['id' => $permiso->id])}}" class="btn-accion-tabla tooltipsC" title="Editar este registro">
                                    <i class="fa fa-fw fa-pencil"></i>
                                </a>
                                <form action="{{route('eliminar_perm_year', ['id' => $permiso->id])}}" class="d-inline form-eliminar" method="POST">
                                    @csrf @method("delete")
                                    <button type="submit" class="btn-accion-tabla eliminar tooltipsC" title="Eliminar este registro">
                                        <i class="fa fa-fw fa-trash text-danger"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-ver-libro" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Categoría</h4>
            </div>
            <div class="modal-body"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
@endsection