@extends("theme.$theme.layout")
@section('titulo')
Gestión Vacaciones
@endsection

@section("styles")
<link href="{{asset("assets/js/bootstrap-fileinput/css/fileinput.min.css")}}" rel="stylesheet" type="text/css"/>
@endsection

@section("scriptsPlugins")
<script src="{{asset("assets/js/bootstrap-fileinput/js/fileinput.min.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/js/locales/es.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/themes/fas/theme.min.js")}}" type="text/javascript"></script>
@endsection

@section('contenido')
<div class="row">
    <div class="col-lg-12">
        @include('includes.mensaje')
        @include('includes.form-error')
        <div class="box box-danger">
            <div class="box-header with-border">
                <h3 class="box-title">Formulario de solicitud de Permiso al Jefe directo</h3>
                <br>
                <h3 class="box-title">Esta página permite CREAR una solicitud de permiso al Jefe Directo.</h3>
                <a href="{{route('permiso_ddi')}}" class="btn btn-info btn-sm pull-right">Volver al listado</a>
            </div>
            <form action="{{route('guardar_permiso_ddi')}}" id="form-general" class="form-horizontal" method="POST" autocomplete="off" enctype="multipart/form-data">
                @csrf
                <div class="box-body">

               <!-- El siguiente campomustra el nombre del usuario que ingresa a la sesión-->  
               <!-- tex = muestra hidden= oculta, readonly = indica un campo NO modificable-->
               <td><input type="text" name="id_usuario" class="form-control"  value="{{session()->get('nombre_usuario', 'Inivitado')}} " readonly/></td> 
                    
                <!-- Seleccion multiple de personal  -->                    
                 <div class="form-group">
                 <label for="year" class="col-lg-3 control-label requerido"> Tipo Permiso a solicitar </label>
                 <div class="col-lg-8">
                 <select name="id_tabla_tipo_permiso" class="form-control">
                        @foreach($permiso_ddiCreate as $usuario)
                        <option value="{{ $usuario->tipo_permiso}}">{{ $usuario->tipo_permiso }}</option>
                        @endforeach                       
                 </select>
                        </div>
                    </div> 
                <!-- Fin seleccion multiple personal -->

                    @include('permiso_ddi.form') <!-- invoca al archivo form.blade.php -->
                </div>
                <div class="box-footer">
                    <div class="col-lg-3"></div>
                    <div class="col-lg-6">
                        @include('includes.boton-form-crear')
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection