@extends("theme.$theme.layout")
@section('titulo')
Gestion Vacaciones
@endsection
@section("scripts")
<script src="{{asset("assets/pages/scripts/libro/index.js")}}" type="text/javascript"></script>
@endsection
<style></style>

@section('contenido')
<div class="row">
    <div class="col-lg-12">
        @csrf
        @include('includes.mensaje')
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Estadisticas de Permisos Departamento de Ingenería </h3> <!-- Titulos de página-->
                <br>
                <h3 class="box-title">Esta página permite visualisar los datos del permiso solicitado del Departamento</h3>
             <!-- <div class="box-tools pull-right">
                    <a href="{{route('crear_permiso_ddi')}}" class="btn btn-block btn-success btn-sm"> 
                        <i class="fa fa-fw fa-plus-circle"></i> Nuevo registro
                    </a>
                </div> -->
            </div>
            <div class="box-body">
                <table class="table table-striped table-bordered table-hover" id="tabla-data">
                    <thead>
                        <tr>
                            <!-- Campos que se verán en la página Permisos DDI-->
                            <th>Id</th>
                            <th>Funcionario</th>
                            <th>Tipo_permiso</th>
                            <th>Cant. días solicitado</th>
                            <th>Fecha inicio</th>
                            <th>Fecha termino</th>
                            <th>Domicilio</th>
                            <th>Ciudad</th>
                            <th>Comuna</th>
                            <th>Teléfono</th>
                            <th>Observaciones</th>
                            <th>Status del Permiso</th>
                            <th class="width70"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($permiso_ddi as $permiso)
                        <tr>
                            
                            <td>{{$permiso->id}}</td>
                            <td>{{$permiso->id_usuario}}</td>
                            <td>{{$permiso->id_tabla_tipo_permiso}}</td>
                            <td>{{$permiso->cant_dias_solicitado}}</td>
                            <td>{{$permiso->fecha_inicio}}</td>
                            <td>{{$permiso->fecha_termino}}</td>
                            <td>{{$permiso->domicilio}}</td>
                            <td>{{$permiso->ciudad}}</td>
                            <td>{{$permiso->comuna}}</td>
                            <td>{{$permiso->telefono}}</td>
                            <td>{{$permiso->observaciones}}</td>
                            <td>{{$permiso->status_permiso}}</td> 
                            <td>
                                <a href="{{route('editar_permiso_ddi', ['id' => $permiso->id])}}" class="btn-accion-tabla tooltipsC" title="Editar este registro">
                                    <i class="fa fa-fw fa-pencil"></i>
                                </a>
                                <a class="nav-link" style="padding:0" target= "_blank" href="{{ route('permiso-pdf', $permiso->id) }}" title="PDF"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>
                            </td>
                        </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-ver-libro" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Categoría</h4>
            </div>
            <div class="modal-body"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
@endsection