@extends("theme.$theme.layout")
@section('titulo')
CLINICA VETERINARIA
@endsection

@section("styles")
<link href="{{asset("assets/js/bootstrap-fileinput/css/fileinput.min.css")}}" rel="stylesheet" type="text/css"/>
@endsection

@section("scriptsPlugins")
<script src="{{asset("assets/js/bootstrap-fileinput/js/fileinput.min.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/js/locales/es.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/themes/fas/theme.min.js")}}" type="text/javascript"></script>
@endsection

@section('contenido')
<div class="row">
    <div class="col-lg-12">
        @include('includes.mensaje')
        @include('includes.form-error')
        <div class="box box-danger">
            <div class="box-header with-border">
                <h3 class="box-title">Crear Prestación Veterinaria</h3>
                <br>
                <h3 class="box-title">Esta página permite CREAR una PRESTACIÓN para atención de la mascota.</h3>
                <br>
                <h3 class="box-title">Si el TIPO de PRESTACIÓN de la mascota no aparece, debe ser creado por al Administrador en la pestaña usuarios</h3>
                <a href="{{route('prestacion')}}" class="btn btn-info btn-sm pull-right">Volver al listado</a>
            </div>
            <form action="{{route('guardar_prestacion')}}" id="form-general" class="form-horizontal" method="POST" autocomplete="off" enctype="multipart/form-data">
                @csrf
                <div class="box-body">
<!-- Seleccion multiple de mascota  -->                    
                <div class="form-group">
                <label for="id_mascota" class="col-lg-3 control-label requerido"> Mascota</label>
                <div class="col-lg-8">
                <select name="id_mascota" class="form-control">
                @foreach( $mascota as $mascotas)
                <option value="{{ $mascotas->id}}">{{ $mascotas->nombre_masc }}</option>
                @endforeach                       
                </select>
                </div>
                </div> 
<!-- Fin seleccion multiple mascota -->
<input type="hidden" name="id_status" id="id_status" class="form-control" value="1" required/>
<!-- Seleccion multiple de Servicio  -->                    
                <div class="form-group">
                <label for="id_servicio" class="col-lg-3 control-label requerido"> Servicio</label>
                <div class="col-lg-8">
                <select name="id_servicio" class="form-control">
                @foreach( $servicio as $servicios)
                <option value="{{ $servicios->id}}">{{ $servicios->nombre_servicio }}</option>
                @endforeach                       
                </select>
                </div>
                </div> 
<!-- Fin seleccion multiple Servicio -->
<div class="form-group">
    <label for="fecha_solic" class="col-lg-3 control-label requerido">Fecha</label>
    <div class="col-lg-8">
    <input type="date" name="fecha_solic" id="fecha_solic" class="form-control" required/>
    </div>
</div>
                    
<div class="form-group">
    <label for="hora_solic" class="col-lg-3 control-label requerido">Hora</label>
    <div class="col-lg-8">
    <input type="time" name="hora_solic" id="hora_solic" class="form-control" required/>
    </div>
</div>
<!-- Seleccion multiple de profesional  -->                    
                <div class="form-group">
                <label for="id_profesional" class="col-lg-3 control-label requerido">Profesional</label>
                <div class="col-lg-8">
                <select name="id_profesional" class="form-control">
                @foreach( $usuarioData as $usuario_Data)
                <option value="{{ $usuario_Data->id}}">{{ $usuario_Data->nombre }}</option>
                @endforeach                           
                </select>
                </div>
                </div> 
<!-- Fin seleccion multiple Profesional -->
<div class="form-group">
    <label for="motivo_ingreso" class="col-lg-3 control-label requerido">Motivo Ingreso</label>
    <div class="col-lg-8">
    <textarea name="motivo_ingreso" id="motivo_ingreso" rows="10" cols="145">Escribe aquí motivo ingreso</textarea>
    </div>
</div>
                </div>
                <div class="box-footer">
                    <div class="col-lg-3"></div>
                    <div class="col-lg-6">
                        @include('includes.boton-form-crear')
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection