@extends("theme.$theme.layout")
@section('titulo')
CLINICA VETERINARIA
@endsection

@section("styles")
<link href="{{asset("assets/js/bootstrap-fileinput/css/fileinput.min.css")}}" rel="stylesheet" type="text/css"/>
@endsection

@section("scriptsPlugins")
<script src="{{asset("assets/js/bootstrap-fileinput/js/fileinput.min.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/js/locales/es.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/themes/fas/theme.min.js")}}" type="text/javascript"></script>
@endsection

@section('contenido')
<div class="row">
    <div class="col-lg-12">
        @include('includes.mensaje')
        @include('includes.form-error')
        <div class="box box-danger">
            <div class="box-header with-border">
                <h3 class="box-title">Editar {{$data->prestacion}}</h3>
                <a href="{{route('prestacion')}}" class="btn btn-info btn-sm pull-right">Volver al listado</a>
            </div>
            <form action="{{route('actualizar_prestacion', $data->id)}}" id="form-general" class="form-horizontal" method="POST" autocomplete="off" enctype="multipart/form-data">
                @csrf @method("put")
                <div class="box-body">
                    
                    
<!-- Seleccion multiple de mascota  -->                        
        <div class="form-group">
                <label for="id_mascota" class="col-lg-3 control-label requerido"> Mascota </label>
                <div class="col-lg-8">
                <select name="id_mascota" class="form-control">
                @foreach ($mascota as $mascotas)  <!-- set de datos que paso a edith -->  
                <option value="{{ $mascotas->id }}" 
                @if ($mascotas->id == $data->id_mascota)
                selected="selected"
                @endif>
                {{ $mascotas->nombre_masc }}</option>  <!-- SET DE DATOS -->  
                @endforeach               
                </select>
                </div>
                </div> 
<!-- Fin seleccion multiple mascota -->
<input type="hidden" name="id_status" id="id_status" class="form-control" value="1" required/>
<!-- Seleccion multiple de Servicio  -->
<div class="form-group">
                <label for="id_servicio" class="col-lg-3 control-label requerido"> Servicio </label>
                <div class="col-lg-8">
                <select name="id_servicio" class="form-control">
                @foreach ($servicio as $servicios)  <!-- set de datos que paso a edith -->  
                <option value="{{ $servicios->id }}" 
                @if ($servicios->id == $data->id_servicio)
                selected="selected"
                @endif>
                {{ $servicios->nombre_servicio }}</option>  <!-- SET DE DATOS -->  
                @endforeach               
                </select>
                </div>
                </div> 
<!-- Fin seleccion multiple Servicio -->
<div class="form-group">
    <label for="fecha_solic" class="col-lg-3 control-label requerido">Fecha</label>
    <div class="col-lg-8">
    <input type="date" name="fecha_solic" id="fecha_solic" class="form-control" value="{{old('fecha_solic', $data->fecha_solic ?? '')}}"  required/>
    </div>
</div>
                    
<div class="form-group">
    <label for="hora_solic" class="col-lg-3 control-label requerido">Hora</label>
    <div class="col-lg-8">
    <input type="time" name="hora_solic" id="hora_solic" class="form-control" value="{{old('hora_solic', $data->hora_solic ?? '')}}" required/>
    </div>
</div>
<!-- Seleccion multiple de profesional  -->
<div class="form-group">
                <label for="id_profesional" class="col-lg-3 control-label requerido"> Servicio </label>
                <div class="col-lg-8">
                <select name="id_profesional" class="form-control">
                @foreach ($usuarioData as $usuarioData)  <!-- set de datos que paso a edith -->  
                <option value="{{ $usuarioData->id }}" 
                @if ($usuarioData->id == $data->id_profesional)
                selected="selected"
                @endif>
                {{ $usuarioData->nombre }}</option>  <!-- SET DE DATOS -->  
                @endforeach               
                </select>
                </div>
                </div> 
<!-- Fin seleccion multiple Profesional -->
<div class="form-group">
    <label for="motivo_ingreso" class="col-lg-3 control-label requerido">Motivo Ingreso</label>
    <div class="col-lg-8">
    <input type="text" name="motivo_ingreso" id="motivo_ingreso" class="form-control" value="{{old('motivo_ingreso', $data->motivo_ingreso ?? '')}}" required/>
    </div>
</div>
                    
                    
                </div>
                <div class="box-footer">
                    <div class="col-lg-3"></div>
                    <div class="col-lg-6">
                        @include('includes.boton-form-editar')
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection