@extends("theme.$theme.layout")
@section('titulo')
CLINICA VETERINARIA
@endsection
@section("scripts")
<script src="{{asset("assets/pages/scripts/libro/index.js")}}" type="text/javascript"></script>
@endsection
<style></style>

@section('contenido')
<div class="row">
    <div class="col-lg-12">
        @csrf
        @include('includes.mensaje')
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">PRESTACIÓN PARA LA MASCOTA </h3> <!-- Titulos de página-->
                <br>
                <h3 class="box-title">Esta página permite CREAR PRESTACIÓN para la mascota</h3>
                <div class="box-tools pull-right">
                    <a href="{{route('crear_prestacion')}}" class="btn btn-block btn-success btn-sm"> <!-- route lista-->
                        <i class="fa fa-fw fa-plus-circle"></i> CREAR NUEVO PRESTACIÓN
                    </a>
                </div>
            </div>
            <div class="box-body">
                <table class="table table-striped table-bordered table-hover" id="tabla-data">
                    <thead>
                        <tr>
                             <!-- Campos que se verán en la página prestacion-->
                            <th>Id</th>
                            <th>Nombre Mascota</th>
                            <th>Status del servicio</th>
                            <th>Servicio</th>
                            <th>Hora de atención</th>
                            <th>Fecha solicitud</th>
                            <th>Profesional</th>
                            <th class="width70"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($prestacion as $prestacion)
                        <tr>
                            <!-- FALTA CAMBIAR LAS VARIABLES PARA MASCOTA-->
                            <td>{{$prestacion->id}}</td>
                            <td>{{$prestacion->nombre_masc}}</td> <!-- cambiar a variables para llamar de aca hacia abajo-->
                            <td>{{$prestacion->status_hora_atenc}}</td>
                            <td>{{$prestacion->nombre_servicio}}</td>
                            <td>{{$prestacion->hora_solic}}</td>
                            <td>{{$prestacion->fecha_solic}}</td>
                            <td>{{$prestacion->nombre}}</td>
                            <td>
                                <a href="{{route('editar_prestacion', ['id' => $prestacion->id])}}" class="btn-accion-tabla tooltipsC" title="Editar este registro">
                                    <i class="fa fa-fw fa-pencil"></i>
                                </a>
                                <form action="{{route('eliminar_prestacion', ['id' => $prestacion->id])}}" class="d-inline form-eliminar" method="POST">
                                    @csrf @method("delete")
                                    <button type="submit" class="btn-accion-tabla eliminar tooltipsC" title="Eliminar este registro">
                                        <i class="fa fa-fw fa-trash text-danger"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-ver-libro" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Categoría</h4>
            </div>
            <div class="modal-body"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
@endsection