@extends("theme.$theme.layout")
@section('titulo')
CLINICA VETERINARIA
@endsection

@section("styles")
<link href="{{asset("assets/js/bootstrap-fileinput/css/fileinput.min.css")}}" rel="stylesheet" type="text/css"/>
@endsection

@section("scriptsPlugins")
<script src="{{asset("assets/js/bootstrap-fileinput/js/fileinput.min.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/js/locales/es.js")}}" type="text/javascript"></script>
<script src="{{asset("assets/js/bootstrap-fileinput/themes/fas/theme.min.js")}}" type="text/javascript"></script>
@endsection

@section('contenido')
<div class="row">
    <div class="col-lg-12">
        @include('includes.mensaje')
        @include('includes.form-error')
        <div class="box box-danger">
            <div class="box-header with-border">
                <h3 class="box-title">Esta página permite CREAR una RAZA para cada tipo de mascota que se va a atender.</h3>
                <br>
                <h3 class="box-title">Si el TIPO de RAZA de la mascota no aparece, debe ser creado por al Administrador en la pestaña usuarios</h3>
                <a href="{{route('raza')}}" class="btn btn-info btn-sm pull-right">Volver al listado</a>
            </div>

            
            <form action="{{route('guardar_raza')}}" id="form-general" class="form-horizontal" method="POST" autocomplete="off" enctype="multipart/form-data">
>
                @csrf
                <div class="box-body">
                
                    @include('raza.form') <!-- llama a fichero form.blade.php llama a raza -->
                    
            <div class="form-group">
    <label for="id_tipomascota" class="col-lg-3 control-label requerido"> Tipo Mascota </label>
    <div class="col-lg-8">
   <select name="id_tipomascota" class="form-control">
                 @foreach($data as $tipomascota)
                           <option value="{{ $tipomascota->id}}">{{ $tipomascota->tipo_mascota }}</option>
                           @endforeach                       
                </select>
    </div>
</div>



                </div>
                <div class="box-footer">
                    <div class="col-lg-3"></div>
                    <div class="col-lg-6">
                        @include('includes.boton-form-crear')
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection