<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These1|   
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*RUTAS PASSWORD RESET*/

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;


Route::get('password/reset', 'Auth\ForgotPasswordController@showLinkRequestForm')->name('password.request');
Route::post('password/email', 'Auth\ForgotPasswordController@sendResetLinkEmail')->name('password.email');
Route::get('password/reset/{token}', 'Auth\ResetPasswordController@showResetForm')->name('password.reset');
Route::post('password/reset', 'Auth\ResetPasswordController@reset')->name('password.update');

Route::get('/', 'InicioController@index')->name('inicio');
Route::get('seguridad/login', 'Seguridad\LoginController@index')->name('login');
Route::post('seguridad/login', 'Seguridad\LoginController@login')->name('login_post');
Route::get('seguridad/logout', 'Seguridad\LoginController@logout')->name('logout');
Route::post('ajax-sesion', 'AjaxController@setSession')->name('ajax')->middleware('auth');
Route::group(['prefix' => 'admin', 'namespace' => 'Admin', 'middleware' => ['auth', 'superadmin']], function () {
    Route::get('', 'AdminController@index');

    /*RUTAS DE USUARIO*/
    Route::get('usuario', 'UsuarioController@index')->name('usuario');
    Route::get('usuario/crear', 'UsuarioController@crear')->name('crear_usuario');
    Route::post('usuario', 'UsuarioController@guardar')->name('guardar_usuario');
    Route::get('usuario/{id}/editar', 'UsuarioController@editar')->name('editar_usuario');
    Route::put('usuario/{id}', 'UsuarioController@actualizar')->name('actualizar_usuario');
    Route::delete('usuario/{id}', 'UsuarioController@eliminar')->name('eliminar_usuario');

    /*RUTAS DE PERMISO  cambiar estas ruta y parametro*/
    Route::get('permiso', 'PermisoController@index')->name('permiso');
    Route::get('permiso/crear', 'PermisoController@crear')->name('crear_permiso');
    Route::post('permiso', 'PermisoController@guardar')->name('guardar_permiso');
    Route::get('permiso/{id}/editar', 'PermisoController@editar')->name('editar_permiso');
    Route::put('permiso/{id}', 'PermisoController@actualizar')->name('actualizar_permiso');
    Route::delete('permiso/{id}', 'PermisoController@eliminar')->name('eliminar_permiso');


    /*RUTAS DEL MENU*/
    Route::get('menu', 'MenuController@index')->name('menu');
    Route::get('menu/crear', 'MenuController@crear')->name('crear_menu');
    Route::post('menu', 'MenuController@guardar')->name('guardar_menu');
    Route::get('menu/{id}/editar', 'MenuController@editar')->name('editar_menu');
    Route::put('menu/{id}', 'MenuController@actualizar')->name('actualizar_menu');
    Route::get('menu/{id}/eliminar', 'MenuController@eliminar')->name('eliminar_menu');
    Route::post('menu/guardar-orden', 'MenuController@guardarOrden')->name('guardar_orden');

    /*RUTAS ROL*/
    Route::get('rol', 'RolController@index')->name('rol');
    Route::get('rol/crear', 'RolController@crear')->name('crear_rol');
    Route::post('rol', 'RolController@guardar')->name('guardar_rol');
    Route::get('rol/{id}/editar', 'RolController@editar')->name('editar_rol');
    Route::put('rol/{id}', 'RolController@actualizar')->name('actualizar_rol');
    Route::delete('rol/{id}', 'RolController@eliminar')->name('eliminar_rol');

    /*RUTAS MENU_ROL*/
    Route::get('menu-rol', 'MenuRolController@index')->name('menu_rol');
    Route::post('menu-rol', 'MenuRolController@guardar')->name('guardar_menu_rol');


    /*RUTAS PERMISO_ROL cambiar o borrar*/
    Route::get('permiso-rol', 'PermisoRolController@index')->name('permiso_rol');
    Route::post('permiso-rol', 'PermisoRolController@guardar')->name('guardar_permiso_rol');
});
/**
 * Rutas Servicio
 */
// palabra reservada :: funsion('nombrepara mostrar en la url', 'nombre del controlador@nombre del la función'-> (''))
Route::get('servicio', 'ServicioController@index')->name('servicio')->middleware('auth');                   // linea OK MOSTAR = index
Route::get('servicio/crear', 'ServicioController@create')->name('crear_servicio')->middleware('auth');      // linea OK CREAR = create 
Route::get('servicio/{id}/edit', 'ServicioController@edit')->name('editar_servicio')->middleware('auth');   // linea OK EDITAR = edit
Route::put('servicio/{id}', 'ServicioController@update')->name('actualizar_servicio')->middleware('auth');  // linea OK ACTUALIZAR = update
Route::delete('servicio/{id}', 'ServicioController@destroy')->name('eliminar_servicio')->middleware('auth');// linea OK BORRAR = destroy
Route::post('servicio', 'ServicioController@store')->name('guardar_servicio')->middleware('auth');          // lista OK GUARDAR = store

/**
 * Rutas Status (Status de las horas de atención)
 */
Route::get('status', 'StatusController@index')->name('status')->middleware('auth');                             // linea  OK MOSTAR = index
Route::get('status/crear', 'StatusController@create')->name('crear_status')->middleware('auth');                // linea  OK CREAR = create 
Route::get('status/{id}/edit', 'StatusController@edit')->name('editar_status')->middleware('auth');             // linea  OK EDITAR = edit
Route::put('statuspermiso/{id}', 'StatusController@update')->name('actualizar_status')->middleware('auth');     // linea  OK ACTUALIZAR = update
Route::delete('status/{id}', 'StatusController@destroy')->name('eliminar_status')->middleware('auth');          // linea  OK BORRAR = destroy
Route::post('status', 'StatusController@store')->name('guardar_status')->middleware('auth');                    // lista  OK GUARDAR = store

/**
 * Rutas TipoMascota
 */
Route::get('tipomascota', 'TipoMascotaController@index')->name('tipomascota')->middleware('auth');                   // linea  OK  MOSTAR = index
Route::get('tipomascota/crear', 'TipoMascotaController@create')->name('crear_tipomascota')->middleware('auth');      // linea  OK  CREAR = create 
Route::get('tipomascota/{id}/edit', 'TipoMascotaController@edit')->name('editar_tipomascota')->middleware('auth');   // linea  OK EDITAR = edit
Route::put('tipomascota/{id}', 'TipoMascotaController@update')->name('actualizar_tipomascota')->middleware('auth');  // linea  OK  ACTUALIZAR = update
Route::delete('tipomascota/{id}', 'TipoMascotaController@destroy')->name('eliminar_tipomascota')->middleware('auth');// linea  OK  BORRAR = destroy
Route::post('tipomascota', 'TipoMascotaController@store')->name('guardar_tipomascota')->middleware('auth');          // lista  OK  GUARDAR = store

/**
 * Rutas Raza
 */
Route::get('raza', 'RazaController@index')->name('raza')->middleware('auth');                   // linea  OK  MOSTAR = index
Route::get('raza/crear', 'RazaController@create')->name('crear_raza')->middleware('auth');      // linea  OK  CREAR = create 
Route::get('raza/{id}/edit', 'RazaController@edit')->name('editar_raza')->middleware('auth');   // linea  OK EDITAR = edit
Route::put('raza/{id}', 'RazaController@update')->name('actualizar_raza')->middleware('auth');  // linea  OK  ACTUALIZAR = update
Route::delete('raza/{id}', 'RazaController@destroy')->name('eliminar_raza')->middleware('auth');// linea  OK  BORRAR = destroy
Route::post('raza', 'RazaController@store')->name('guardar_raza')->middleware('auth');          // lista  OK  GUARDAR = store
// Route::get('raza/raza-pdf/{id}','RazaController@razaPDF')->name('raza-pdf');

/**
 * Rutas Mascota
 */
Route::get('mascota', 'MascotaController@index')->name('mascota')->middleware('auth');                   // linea OK MOSTAR = index
Route::get('mascota/crear', 'MascotaController@create')->name('crear_mascota')->middleware('auth');      // linea OK CREAR = create 
Route::get('mascota/{id}/edit', 'MascotaController@edit')->name('editar_mascota')->middleware('auth');   // linea OK EDITAR = edit
Route::put('mascota/{id}', 'MascotaController@update')->name('actualizar_mascota')->middleware('auth');  // linea OK ACTUALIZAR = update
Route::delete('mascota/{id}', 'MascotaController@destroy')->name('eliminar_mascota')->middleware('auth');// linea OK BORRAR = destroy
Route::post('mascota', 'MascotaController@store')->name('guardar_mascota')->middleware('auth');          // lista OK GUARDAR = store
Route::get('mascota/{id}/show', 'MascotaController@show')->name('show_mascota')->middleware('auth'); 


/**
 * Rutas Prestación
 */
Route::get('prestacion', 'PrestacionController@index')->name('prestacion')->middleware('auth');                   // linea OK MOSTAR = index
Route::get('prestacion/crear', 'PrestacionController@create')->name('crear_prestacion')->middleware('auth');      // linea OK CREAR = create 
Route::get('prestacion/{id}/edit', 'PrestacionController@edit')->name('editar_prestacion')->middleware('auth');   // linea OK EDITAR = edit
Route::put('prestacion/{id}', 'PrestacionController@update')->name('actualizar_prestacion')->middleware('auth');  // linea OK ACTUALIZAR = update
Route::delete('prestacion/{id}', 'PrestacionController@destroy')->name('eliminar_prestacion')->middleware('auth');// linea OK BORRAR = destroy
//Route::post('prestacion', 'PrestacionController@store')->name('guardar_prestacion')->middleware('auth');          // lista OK GUARDAR = store
Route::get('prestacion/{id}/show', 'PrestacionController@show')->name('show_prestacion')->middleware('auth'); 