<?php $__env->startSection('titulo'); ?>
CLINICA VETERINARIA
<?php $__env->stopSection(); ?>
<?php $__env->startSection("scripts"); ?>
<script src="<?php echo e(asset("assets/pages/scripts/libro/index.js")); ?>" type="text/javascript"></script>
<?php $__env->stopSection(); ?>
<style></style>

<?php $__env->startSection('contenido'); ?>
<div class="row">
    <div class="col-lg-12">
        <?php echo csrf_field(); ?>
        <?php echo $__env->make('includes.mensaje', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Status Hora de atención (Solicitud, cancelado, borrado)</h3> <!-- Titulos de página-->
                <br>
                <h3 class="box-title">Esta pagina permite crear estatus de CITAS</h3>
                <div class="box-tools pull-right">
                    <a href="<?php echo e(route('crear_status')); ?>" class="btn btn-block btn-success btn-sm"> <!-- route lista, aca va el NAME que aparece en la ruta-->
                        <i class="fa fa-fw fa-plus-circle"></i> CREAR NUEVO ESTATUS
                    </a>
                </div>
            </div>
            <div class="box-body">
                <table class="table table-striped table-bordered table-hover" id="tabla-data">
                    <thead>
                        <tr>
                            <th>Estatus de la Cita</th>
                            <th class="width70"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $status_hora_atenc; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            
                            <td><?php echo e($status->status_hora_atenc); ?></td>
                            <td>
                                <a href="<?php echo e(route('editar_status', ['id' => $status->id])); ?>" class="btn-accion-tabla tooltipsC" title="Editar este registro">
                                    <i class="fa fa-fw fa-pencil"></i>
                                </a>
                                <form action="<?php echo e(route('eliminar_status', ['id' => $status->id])); ?>" class="d-inline form-eliminar" method="POST">
                                    <?php echo csrf_field(); ?> <?php echo method_field("delete"); ?>
                                    <button type="submit" class="btn-accion-tabla eliminar tooltipsC" title="Eliminar este registro">
                                        <i class="fa fa-fw fa-trash text-danger"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-ver-libro" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Categoría</h4>
            </div>
            <div class="modal-body"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("theme.$theme.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\gestion_vacaciones\resources\views/status/index.blade.php ENDPATH**/ ?>