<?php $__env->startSection('titulo'); ?>
Gestion Vacaciones
<?php $__env->stopSection(); ?>
<?php $__env->startSection("scripts"); ?>
<script src="<?php echo e(asset("assets/pages/scripts/libro/index.js")); ?>" type="text/javascript"></script>
<?php $__env->stopSection(); ?>
<style></style>

<?php $__env->startSection('contenido'); ?>
<div class="row">
    <div class="col-lg-12">
        <?php echo csrf_field(); ?>
        <?php echo $__env->make('includes.mensaje', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Estadisticas de Permisos Departamento de Ingenería </h3> <!-- Titulos de página-->
                <br>
                <h3 class="box-title">Esta página permite visualisar los datos del permiso solicitado del Departamento</h3>
                <div class="box-tools pull-right">
                    <a href="<?php echo e(route('crear_mispermisos')); ?>" class="btn btn-block btn-success btn-sm"> <!-- route lista-->
                        <i class="fa fa-fw fa-plus-circle"></i> Nuevo registro
                    </a>
                </div>
            </div>
            <div class="box-body">
                <table class="table table-striped table-bordered table-hover" id="tabla-data">
                    <thead>
                        <tr>
                            <!-- Campos que se verán en la página Permisos DDI-->
                            <th>Id</th>
                            <th>Funcionario</th>
                            <th>Tipo_permiso</th>
                            <th>Cant. días solicitado</th>
                            <th>Fecha inicio</th>
                            <th>Fecha termino</th>
                            <th>Domicilio</th>
                            <th>Ciudad</th>
                            <th>Comuna</th>
                            <th>Teléfono</th>
                            <th>Status del Permiso</th>
                            <th class="width70"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $permiso_ddi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permiso): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            
                            <td><?php echo e($permiso->id); ?></td>
                            <td><?php echo e($permiso->id_usuario); ?></td>
                            <td><?php echo e($permiso->id_tabla_tipo_permiso); ?></td>
                            <td><?php echo e($permiso->cant_dias_solicitado); ?></td>
                            <td><?php echo e($permiso->fecha_inicio); ?></td>
                            <td><?php echo e($permiso->fecha_termino); ?></td>
                            <td><?php echo e($permiso->domicilio); ?></td>
                            <td><?php echo e($permiso->ciudad); ?></td>
                            <td><?php echo e($permiso->comuna); ?></td>
                            <td><?php echo e($permiso->telefono); ?></td>
                            <td><?php echo e($permiso->observaciones); ?></td>

                            <td>
                                <a href="<?php echo e(route('editar_mispermisos', ['id' => $permiso->id])); ?>" class="btn-accion-tabla tooltipsC" title="Editar este registro">
                                    <i class="fa fa-fw fa-pencil"></i>
                                </a>
                                <form action="<?php echo e(route('eliminar_mispermisos', ['id' => $permiso->id])); ?>" class="d-inline form-eliminar" method="POST">
                                    <?php echo csrf_field(); ?> <?php echo method_field("delete"); ?>
                                    <button type="submit" class="btn-accion-tabla eliminar tooltipsC" title="Eliminar este registro">
                                        <i class="fa fa-fw fa-trash text-danger"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-ver-libro" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Categoría</h4>
            </div>
            <div class="modal-body"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("theme.$theme.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Laravel\gestion_vacaciones 03 oct\gestion_vacaciones\resources\views/mispermisos/index.blade.php ENDPATH**/ ?>