<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo $__env->yieldContent('titulo', 'AdminImprenta'); ?> | Enoks Spa.</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="<?php echo e(asset("assets/$theme/bower_components/bootstrap/dist/css/bootstrap.min.css")); ?>">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo e(asset("assets/$theme/bower_components/font-awesome/css/font-awesome.min.css")); ?>">
    <!-- Ionicons -->
    <link rel="stylesheet" href="<?php echo e(asset("assets/$theme/bower_components/Ionicons/css/ionicons.min.css")); ?>">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo e(asset("assets/$theme/dist/css/AdminLTE.min.css")); ?>">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
           folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="<?php echo e(asset("assets/$theme/dist/css/skins/_all-skins.min.css")); ?>">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <?php echo $__env->yieldContent("styles"); ?>

    <link rel="stylesheet" href="<?php echo e(asset("assets/css/custom.css")); ?>">


    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
      <![endif]-->

    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
</head>

   <!-- <body class="hold-transition skin-blue layout-boxed sidebar-mini">-->
    <body class="hold-transition skin-blue fixed sidebar-mini">
    
    <!-- Site wrapper -->
    <div class="wrapper">
        <!-- Inicio Header -->
        <?php echo $__env->make("theme/$theme/header", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Fin Header -->
        <!-- Inicio Aside -->
        <?php echo $__env->make("theme/$theme/aside", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Fin Aside -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content">
                <?php echo $__env->yieldContent('contenido'); ?>
            </section>
        </div>
        <!--Inicio Footer -->
        <?php echo $__env->make("theme/$theme/footer", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Fin Footer -->
        <!--Inicio de ventana modal para login con más de un rol -->
		<?php if(session()->get("roles") && count(session()->get("roles")) > 1): ?>
            <?php echo csrf_field(); ?>
            <div class="modal fade" id="modal-seleccionar-rol" data-rol-set="<?php echo e(empty(session()->get("rol_id")) ? 'NO' : 'SI'); ?>" tabindex="-1" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Roles de Usuario</h4>
                        </div>
                        <div class="modal-body">
                            <p>Cuentas con mas de un Rol en la plataforma, a continuación seleccione con cual de ellos desea trabajar</p>
                            <?php $__currentLoopData = session()->get("roles"); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $rol): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a href="#" class="asignar-rol" data-rolid="<?php echo e($rol['id']); ?>" data-rolnombre="<?php echo e($rol["nombre"]); ?>">
                                        <?php echo e($rol["nombre"]); ?>

                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
    <script src="<?php echo e(asset("assets/$theme/bower_components/jquery/dist/jquery.min.js")); ?>"></script>
    <?php echo $__env->yieldPushContent('scripts_stack'); ?>
    <!-- Bootstrap 3.3.7 -->
    <script src="<?php echo e(asset("assets/$theme/bower_components/bootstrap/dist/js/bootstrap.min.js")); ?>"></script>
    <!-- SlimScroll -->
    <script src="<?php echo e(asset("assets/$theme/bower_components/jquery-slimscroll/jquery.slimscroll.min.js")); ?>"></script>
    <!-- FastClick -->
    <script src="<?php echo e(asset("assets/$theme/bower_components/fastclick/lib/fastclick.js")); ?>"></script>
    <!-- AdminLTE App -->
    <script src="<?php echo e(asset("assets/$theme/dist/js/adminlte.min.js")); ?>"></script>
    <!-- AdminLTE for demo purposes -->
    <?php echo $__env->yieldContent("scriptsPlugins"); ?>
    <script src="<?php echo e(asset("assets/js/jquery-validation/jquery.validate.min.js")); ?>"></script>
    <script src="<?php echo e(asset("assets/js/jquery-validation/localization/messages_es.min.js")); ?>"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="<?php echo e(asset("assets/js/scripts.js")); ?>"></script>
    <script src="<?php echo e(asset("assets/js/funciones.js")); ?>"></script>
    <?php echo $__env->yieldContent("scripts"); ?>
</body>

</html>
<?php /**PATH C:\Laravel\adminimprenta\resources\views/theme/lte/layout.blade.php ENDPATH**/ ?>