<?php $__env->startSection('titulo'); ?>
AdminImprenta
<?php $__env->stopSection(); ?>

<?php $__env->startSection("scripts"); ?>
<script src="<?php echo e(asset("assets/pages/scripts/libro/index.js")); ?>" type="text/javascript"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contenido'); ?>
<div class="row">
    <div class="col-lg-12">
        <?php echo csrf_field(); ?>
        <?php echo $__env->make('includes.mensaje', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Clientes</h3>
                <div class="box-tools pull-right">
                    <a href="<?php echo e(route('crear_cliente')); ?>" class="btn btn-block btn-success btn-sm">
                        <i class="fa fa-fw fa-plus-circle"></i> Nuevo registro
                    </a>
                </div>
            </div>
            <div class="box-body">
                <table class="table table-striped table-bordered table-hover" id="tabla-data">
                    <thead>
                        <tr>
                            <th>Tipo</th>
                            <th>Nombre</th>
                            <th>Teléfono</th>
                            <th>Contacto</th>
                            <th>Email</th>
                            <th>Sitio web</th>
                            <th>Dirección</th>
                            <th class="width70"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            
                            <td><?php echo e($data->tipo); ?></td>
                            <td><?php echo e($data->nombre); ?></td>
                            <td><?php echo e($data->telefono); ?></td>
                            <td><?php echo e($data->contacto); ?></td>
                            <td><?php echo e($data->email); ?></td>
                            <td><?php echo e($data->sitioweb); ?></td>
                            <td><?php echo e($data->direccion); ?></td>
                            <td>
                                <a href="<?php echo e(route('editar_cliente', ['id' => $data->id])); ?>" class="btn-accion-tabla tooltipsC" title="Editar este registro">
                                    <i class="fa fa-fw fa-pencil"></i>
                                </a>
                                <form action="<?php echo e(route('eliminar_cliente', ['id' => $data->id])); ?>" class="d-inline form-eliminar" method="POST">
                                    <?php echo csrf_field(); ?> <?php echo method_field("delete"); ?>
                                    <button type="submit" class="btn-accion-tabla eliminar tooltipsC" title="Eliminar este registro">
                                        <i class="fa fa-fw fa-trash text-danger"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-ver-libro" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Categoría</h4>
            </div>
            <div class="modal-body"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>





<?php echo $__env->make("theme.$theme.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adminimprenta/public_html/enoks6/resources/views/cliente/index.blade.php ENDPATH**/ ?>