<?php $__env->startSection('titulo'); ?>
Libros Prestados
<?php $__env->stopSection(); ?>

<?php $__env->startSection("scripts"); ?>
<script src="<?php echo e(asset("assets/pages/scripts/libro-prestamo/index.js")); ?>" type="text/javascript"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contenido'); ?>
<div class="row">
    <div class="col-lg-12">
        <?php echo csrf_field(); ?>
        <?php echo $__env->make('includes.mensaje', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Libros prestados</h3>
                <div class="box-tools pull-right">
                    <a href="<?php echo e(route('libro-prestamo.crear')); ?>" class="btn btn-block btn-success btn-sm">
                        <i class="fa fa-fw fa-plus-circle"></i> Prestar nuevo libro
                    </a>
                </div>
            </div>
            <div class="box-body">
                <table class="table table-striped table-bordered table-hover" id="tabla-data">
                    <thead>
                        <tr>
                            <th></th>
                            <th>Título</th>
                            <th>Prestado por</th>
                            <th>Prestado a</th>
                            <th>Fecha prestamo</th>
                            <th>Fecha devolución</th>
                            <th class="width70"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $libros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="text-center"><img src="<?php echo e(Storage::url("imagenes/caratulas/" . $data->libro->foto)); ?>" alt="caratula del libro" style="width:50px"></td>
                            <td><?php echo e($data->libro->titulo); ?></td>
                            <td><?php echo e($data->usuario->nombre); ?></td>
                            <td><?php echo e($data->prestado_a); ?></td>
                            <td><?php echo e($data->fecha_prestamo); ?></td>
                            <td><?php echo e($data->fecha_devolucion ?? 'Prestado'); ?></td>
                            <td></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("theme.$theme.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Laravel\adminimprenta-v2\resources\views/libro-prestamo/index.blade.php ENDPATH**/ ?>