<?php $__env->startSection('titulo'); ?>
Productos
<?php $__env->stopSection(); ?>

<?php $__env->startSection("scripts"); ?>
<script src="<?php echo e(asset("assets/pages/scripts/libro/index.js")); ?>" type="text/javascript"></script>
<?php $__env->stopSection(); ?>
<style></style>

<?php $__env->startSection('contenido'); ?>
<div class="row">
    <div class="col-lg-12">
        <?php echo csrf_field(); ?>
        <?php echo $__env->make('includes.mensaje', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Presupuestos</h3>
                <div class="box-tools pull-right">
                    <a href="<?php echo e(route('crear_presupuesto')); ?>" class="btn btn-block btn-success btn-sm">
                        <i class="fa fa-fw fa-plus-circle"></i> Nuevo registro
                    </a>
                </div>
            </div>
            <div class="box-body">
                <table class="table table-striped table-bordered table-hover" id="tabla-data">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Cliente</th>
                            <th>Campaña</th>
                            <th>Vendedor</th>
                            <th>estado</th>
                            <th>Fecha actualización</th>
                            <th class="width60"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $presupuestoIndex; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            
                            <td><?php echo e($data->id); ?></td>
                            <td><?php echo e($data->cliente); ?></td>
                            <td><?php echo e($data->campania); ?></td>
                            <td><?php echo e($data->vendedor); ?></td>
                            <td><?php echo e($data->estado_id); ?></td>
                            <td><?php echo e($data->updated_at); ?></td>
                            <td>
                            <a class="nav-link" style="padding:0" target= "_blank" href="<?php echo e(route('presupuesto-pdf', $data->id)); ?>" title="PDF"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>
                               <!-- <a href="<?php echo e(route('ver_ingreso', ['id' => $data->id])); ?>" class="btn-accion-tabla tooltipsC" title="Ver este registro">
                                    <i class="fa fa-fw fa-eye"></i>
                                </a>
                            -->
                                <a href="<?php echo e(route('editar_presupuesto', ['id' => $data->id])); ?>" class="btn-accion-tabla tooltipsC" title="Editar este registro">
                                    <i class="fa fa-fw fa-pencil"></i>
                                </a>
                                <form action="<?php echo e(route('eliminar_presupuesto', ['id' => $data->id])); ?>" class="d-inline form-eliminar" method="POST">
                                    <?php echo csrf_field(); ?> <?php echo method_field("delete"); ?>
                                    <button type="submit" class="btn-accion-tabla eliminar tooltipsC" title="Eliminar este registro">
                                        <i class="fa fa-fw fa-trash text-danger"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("theme.$theme.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Laravel\gestion_vacaciones\resources\views/presupuesto/index.blade.php ENDPATH**/ ?>